USE DataMiningDW
GO

SELECT TOP 10 PERCENT * 
FROM Cells 
ORDER BY NEWID()
GO

WITH CTE AS (
	SELECT * FROM OPENQUERY(DM,'
			SELECT t.[ID],Cluster() as Cl
			FROM CellsClusters
			NATURAL PREDICTION JOIN 
			OPENQUERY([Data Mining], 
				''SELECT * FROM dbo.Cells'') AS t')) 
UPDATE dbo.Cells
SET Cluster = Cl
FROM dbo.Cells JOIN CTE
ON CTE.ID = dbo.Cells.ID;
GO

SELECT *,1 AS Cluster FROM OPENQUERY
 (DM, 'SELECT * FROM CellsClusters.CASES WHERE IsInNode (''001'')') as T
    UNION ALL
SELECT *,2  FROM OPENQUERY
 (DM, 'SELECT * FROM CellsClusters.CASES WHERE IsInNode (''002'')') as T
UNION ALL
SELECT *,3 FROM OPENQUERY
 (DM, 'SELECT * FROM CellsClusters.CASES WHERE IsInNode (''003'')') as T
  UNION ALL
SELECT *,4 FROM OPENQUERY
 (DM, 'SELECT * FROM CellsClusters.CASES WHERE IsInNode (''004'')') as T
   UNION ALL
SELECT *,5 FROM OPENQUERY
 (DM, 'SELECT * FROM CellsClusters.CASES WHERE IsInNode (''005'')') as T
   UNION ALL
SELECT *,6 FROM OPENQUERY
 (DM, 'SELECT * FROM CellsClusters.CASES WHERE IsInNode (''006'')') as T;
 GO

 USE AdventureWorksDW 
 GO

SELECT [ID],1 AS Cluster 
INTO [Customers Clusters]
FROM OPENQUERY
 (DMS, 'SELECT * FROM [Customers Clusters].CASES WHERE IsInNode (''008'')') as T
    UNION ALL
SELECT [ID],2  FROM OPENQUERY
 (DMS, 'SELECT * FROM [Customers Clusters].CASES WHERE IsInNode (''009'')') as T;
GO

